/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DKnob2
extends JComponent {
    private static final long serialVersionUID = -3944978568068155143L;
    private static final float START = 225.0f;
    private static final float LENGTH = 270.0f;
    private static final float PI = 3.1415f;
    private static final float START_ANG = 3.926875f;
    private static final float LENGTH_ANG = 4.7122498f;
    private static final float MULTIP = 57.29747f;
    private static final Color DEFAULT_FOCUS_COLOR = new Color(0x8080FF);
    public static final Color DARK = new Color(64, 64, 64, 224);
    public static final Color DARK_T = new Color(64, 64, 64, 128);
    public static final Color DARK_L = new Color(128, 128, 128, 160);
    public static final Color LIGHT_D = new Color(160, 160, 160, 160);
    public static final Color LIGHT = new Color(192, 192, 192, 160);
    public static final Color LIGHT_T = new Color(192, 192, 192, 128);
    private float DRAG_SPEED = 0.01f;
    private float CLICK_SPEED = 0.01f;
    private int size;
    private int middle;
    private String label = "";
    private String type = "";
    public static final int SIMPLE = 1;
    public static final int ROUND = 2;
    private int dragType = 2;
    private Polygon knob = new Polygon();
    private static final Dimension MIN_SIZE = new Dimension(30, 40);
    private static final Dimension PREF_SIZE = new Dimension(40, 60);
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private ChangeEvent changeEvent = null;
    private EventListenerList listenerList = new EventListenerList();
    private Arc2D hitArc = new Arc2D.Float(2);
    private float ang = 3.926875f;
    private float val;
    private int lowInt = 0;
    private int highInt = 100;
    private int medInt = 0;
    private int divisor = 0;
    private int dragpos = -1;
    private float startVal;
    private Color focusColor;
    private double lastAng;

    public DKnob2(String label) {
        this(label, "");
    }

    public DKnob2(String label, String type) {
        this.label = label;
        this.type = type;
        int n = 120;
        for (int i = 0; i < n; ++i) {
            int y = 20 + (int)(0.5 + (Math.sin((double)i * 3.141592 / 4.0) * 1.5 + 20.0) * Math.sin((double)i * 3.141592 * 2.0 / (double)n));
            int x = 20 + (int)(0.5 + (Math.sin((double)i * 3.141592 / 4.0) * 1.5 + 20.0) * Math.cos((double)i * 3.141592 * 2.0 / (double)n));
            this.knob.addPoint(x, y);
        }
        this.focusColor = DEFAULT_FOCUS_COLOR;
        this.setPreferredSize(PREF_SIZE);
        this.setFocusable(true);
        this.hitArc.setAngleStart(235.0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                DKnob2.this.dragpos = me.getX() + me.getY();
                DKnob2.this.startVal = DKnob2.this.val;
                int xpos = DKnob2.this.middle - me.getX();
                int ypos = DKnob2.this.middle - me.getY();
                DKnob2.this.lastAng = Math.atan2(xpos, ypos);
                DKnob2.this.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                DKnob2.this.hitArc.setAngleExtent(-290.0);
                if (DKnob2.this.hitArc.contains(me.getX(), me.getY())) {
                    DKnob2.this.hitArc.setAngleExtent(57.29747f * (DKnob2.this.ang - 3.926875f) - 10.0f);
                    if (DKnob2.this.hitArc.contains(me.getX(), me.getY())) {
                        DKnob2.this.decValue();
                    } else {
                        DKnob2.this.incValue();
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (DKnob2.this.dragType == 1) {
                    float f = DKnob2.this.DRAG_SPEED * (float)(me.getX() + me.getY() - DKnob2.this.dragpos);
                    DKnob2.this.setValue(DKnob2.this.startVal + f);
                } else if (DKnob2.this.dragType == 2) {
                    int xpos = DKnob2.this.middle - me.getX();
                    int ypos = DKnob2.this.middle - me.getY();
                    double ang = Math.atan2(xpos, ypos);
                    double diff = DKnob2.this.lastAng - ang;
                    DKnob2.this.setValue((float)((double)DKnob2.this.getValue() + diff / 4.712249755859375));
                    DKnob2.this.lastAng = ang;
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k == 39) {
                    DKnob2.this.incValue();
                } else if (k == 37) {
                    DKnob2.this.decValue();
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DKnob2.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DKnob2.this.repaint();
            }
        });
    }

    public void setDragType(int type) {
        this.dragType = type;
    }

    public int getDragType() {
        return this.dragType;
    }

    private void incValue() {
        this.setValue(this.val + this.CLICK_SPEED);
    }

    private void decValue() {
        this.setValue(this.val - this.CLICK_SPEED);
    }

    public float getValue() {
        return this.val;
    }

    public int getIntValue() {
        if (this.medInt > 0) {
            if ((double)this.val > 0.5) {
                return this.medInt + (int)(2.0 * ((double)this.val - 0.5) * (double)(this.highInt - this.medInt));
            }
            return this.lowInt + (int)(2.0f * this.val * (float)(this.medInt - this.lowInt));
        }
        return this.lowInt + (int)(this.val * (float)(this.highInt - this.lowInt));
    }

    public void setIntValue(int val) {
        if (this.medInt > 0) {
            if (val > this.medInt) {
                this.setValue(0.5f + 0.5f * (float)(val - this.medInt) / (float)(this.highInt - this.medInt));
            } else {
                this.setValue(0.5f * (float)(val - this.lowInt) / (float)(this.medInt - this.lowInt));
            }
        } else {
            this.setValue(1.0f * (float)(val - this.lowInt) / (float)(this.highInt - this.lowInt));
        }
    }

    public void setValue(float val) {
        if (val < 0.0f) {
            val = 0.0f;
        }
        if (val > 1.0f) {
            val = 1.0f;
        }
        this.val = val;
        this.ang = 3.926875f - 4.7122498f * val;
        this.repaint();
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener cl) {
        this.listenerList.add(ChangeListener.class, cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listenerList.remove(ChangeListener.class, cl);
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    protected void fireChangeEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight() - 10;
            this.size = Math.min(width, height) - 5;
            this.middle = this.size / 2;
            g2d.setBackground(this.getParent().getBackground());
            g2d.addRenderingHints(AALIAS);
            this.hitArc.setFrame(1.0, 1.0, this.size + 12, this.size + 12);
            g2d.scale((double)this.size / 30.0, (double)this.size / 30.0);
            this.drawKnob(g2d);
        }
    }

    private void drawKnob(Graphics2D g2d) {
        g2d.scale(0.5, 0.5);
        g2d.drawString(this.label, 2, 10);
        g2d.scale(2.0, 2.0);
        g2d.translate(0, 6);
        if (this.hasFocus()) {
            g2d.setColor(this.focusColor);
            g2d.fill(new Arc2D.Double(0.0, 0.0, 27.0, 27.0, 90.0, 360.0, 0));
        }
        g2d.setColor(DARK);
        g2d.fill(new Arc2D.Double(1.0, 1.0, 25.0, 25.0, 90.0, 360.0, 0));
        g2d.setColor(DARK_L);
        g2d.fill(new Arc2D.Double(2.0, 2.0, 22.0, 22.0, 90.0, 360.0, 0));
        g2d.setColor(LIGHT_D);
        g2d.draw(new Arc2D.Double(3.0, 3.0, 21.0, 21.0, 75.0, 120.0, 0));
        g2d.setColor(LIGHT);
        g2d.draw(new Arc2D.Double(4.0, 4.0, 20.0, 20.0, 122.5, 25.0, 0));
        g2d.setColor(DARK);
        g2d.fill(new Arc2D.Double(5.0, 5.0, 18.0, 18.0, 90.0, 360.0, 0));
        g2d.setColor(DARK_T);
        g2d.fill(new Arc2D.Double(9.0, 9.0, 18.0, 18.0, 90.0, 360.0, 0));
        g2d.setColor(DARK_L);
        g2d.fill(new Arc2D.Double(6.0, 6.0, 16.0, 16.0, 90.0, 360.0, 0));
        g2d.setColor(DARK_T);
        g2d.draw(new Arc2D.Double(7.0, 7.0, 14.0, 14.0, 270.0, 90.0, 0));
        g2d.setColor(LIGHT_D);
        g2d.draw(new Arc2D.Double(7.0, 7.0, 15.0, 15.0, 90.0, 90.0, 0));
        g2d.setColor(LIGHT_D);
        g2d.fill(new Arc2D.Double(7.0, 7.0, 14.0, 14.0, (double)(180.0f * this.ang) / 3.141592 - 60.0, 120.0, 0));
        g2d.setColor(DARK);
        g2d.draw(new Arc2D.Double(6.0, 6.0, 16.0, 16.0, (double)(180.0f * this.ang) / 3.141592 - 1.0, 2.0, 2));
        g2d.setColor(DARK);
        g2d.draw(new Arc2D.Double(5.0, 5.0, 18.0, 18.0, (double)(180.0f * this.ang) / 3.141592 - 8.0, 16.0, 0));
        g2d.draw(new Arc2D.Double(4.0, 4.0, 20.0, 20.0, (double)(180.0f * this.ang) / 3.141592 - 4.0, 8.0, 0));
        g2d.scale(0.5, 0.5);
        if (this.divisor != 0) {
            g2d.drawString("" + (double)this.getIntValue() * 1.0 / (double)this.divisor + " " + this.type, 10, 64);
        } else {
            g2d.drawString("" + this.getIntValue() + " " + this.type, 10, 64);
        }
    }

    public void setInterval(int low, int high) {
        this.lowInt = low;
        this.highInt = high;
    }

    public void setInterval(int low, int med, int high) {
        this.lowInt = low;
        this.highInt = high;
        this.medInt = med;
    }

    public void setDivisor(int divisor) {
        this.divisor = divisor;
    }

    public static void main(String[] args) {
        JFrame win = new JFrame("DTest!");
        win.getContentPane().setLayout(new BorderLayout());
        win.setSize(120, 140);
        JPanel volumePanel = new JPanel(new BorderLayout());
        volumePanel.setBackground(new Color(180, 180, 195));
        win.getContentPane().add((Component)volumePanel, "Center");
        DKnob2 ts = new DKnob2("Volume", "");
        volumePanel.add((Component)ts, "Center");
        ts.setInterval(0, 15);
        win.setVisible(true);
    }
}

